/*******************************************************************************
 *
 *      A L T R O N I C S    Z 7 0 8 0    L C D   &   T O U C H S C R E E N
 *
 *                             D R I V E R
 *
 *      Copyright A Levido 2013 - All Rights Reserved
 *
 ******************************************************************************/
#ifndef DISPLAY_H
#define DISPLAY_H
#include "genericTypeDefs.h"

/* API ************************************************************************/
/** Initialise lcd and touchscreen */
void lcdInit(UINT32 bgColour);

/** Shut LCD down */
void lcdShutdown();

/** Wake LCD up
 * @param level     - backlight level from 0 (off) to 31 (max) */
void lcdWakeup(UINT8 level);

/** Set Backlight Level
 *  @param level    - backlight level from 0 (off) to 31 (max) */
void lcdSetBacklight(UINT8 level);

/** Draw a single Pixel
 *  @param x        - x coordinate
 *  @param y        - y coordinate
 *  @param colour   - colour of block in 5:6:5 RGB format */
void lcdPutPixel(INT16 x, INT16 y, UINT16 colour);

/** Draw a Filled Block
 *  @param x1       - leftmost pixel
 *  @param y1       - topmost pixel
 *  @param x2       - rightmost pixel
 *  @param y2       - bottommost pixel
 *  @param colour   - colour of block in 5:6:5 RGB format */
void lcdBlock(INT16 x1, INT16 y1, INT16 x2, INT16 y2, UINT16 colour);

#endif
